/*
 * Decompiled with CFR 0.152.
 */
package wafflestomper.ghostwriter.gui.screen;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wafflestomper.ghostwriter.Ghostwriter;
import wafflestomper.ghostwriter.gui.GhostLayer;
import wafflestomper.ghostwriter.gui.IGhostBook;
import wafflestomper.ghostwriter.utilities.BookUtilities;

@OnlyIn(value=Dist.CLIENT)
public class GhostwriterEditBookScreen
extends BookEditScreen
implements IGhostBook {
    protected final GhostLayer ghostLayer = new GhostLayer(this, (Screen)this, true);
    private int currPageLineCount = 0;
    private long lastPageLineCountUpdate = 0L;

    public GhostwriterEditBookScreen(Player editingPlayer, ItemStack book, InteractionHand hand) {
        super(editingPlayer, book, hand);
        this.f_98073_ = new TextFieldHelper(() -> this.f_98071_, p_238772_1_ -> {
            this.f_98071_ = p_238772_1_;
            this.ghostLayer.setBookTitle(this.f_98071_);
        }, () -> ((GhostwriterEditBookScreen)this).m_98180_(), arg_0 -> ((GhostwriterEditBookScreen)this).m_98147_(arg_0), p_238771_0_ -> p_238771_0_.length() <= 32);
    }

    public void m_7856_() {
        super.m_7856_();
        this.ghostLayer.init();
        this.f_98053_.m_93674_(120);
        this.f_98054_.m_93674_(120);
        this.f_98052_.m_93674_(120);
        this.f_98055_.m_93674_(120);
        this.f_98053_.f_93620_ = 5;
        this.f_98054_.f_93620_ = 5;
        this.f_98052_.f_93620_ = 5;
        this.f_98055_.f_93620_ = 5;
        this.f_98053_.f_93621_ = 120;
        this.f_98054_.f_93621_ = 120;
        this.f_98052_.f_93621_ = 145;
        this.f_98055_.f_93621_ = 145;
        this.updateVanillaButtons();
    }

    public void m_86600_() {
        this.ghostLayer.tick();
        super.m_86600_();
    }

    public void m_98184_() {
        this.ghostLayer.updateButtons();
    }

    private int getCurrPageLineCount() {
        if (System.currentTimeMillis() - this.lastPageLineCountUpdate >= 250L) {
            this.currPageLineCount = BookUtilities.splitIntoPages((String)this.m_98191_(), (int)0).get((int)0).lines.length;
            this.lastPageLineCountUpdate = System.currentTimeMillis();
        }
        return this.currPageLineCount;
    }

    @ParametersAreNonnullByDefault
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.f_98067_ && this.f_98071_.length() > 15) {
            String textLen = "Title length: " + this.f_98071_.length();
            guiGraphics.m_280488_(this.f_96547_, textLen, 169, 20, 0xFF3333);
            Object textTitle = this.f_98071_;
            textTitle = (String)textTitle + (this.f_98068_ / 6 % 2 == 0 ? ChatFormatting.BLACK : ChatFormatting.GRAY) + "_";
            int bookLeftSide = (this.f_96543_ - 192) / 2;
            int titleWidth = this.f_96547_.m_92895_((String)textTitle);
            int titleMinX = bookLeftSide + 36 + (114 - titleWidth) / 2;
            int titleMaxX = titleMinX + titleWidth;
            guiGraphics.m_280509_(titleMinX - 5, 48, titleMaxX + 5, 60, -1556);
            guiGraphics.m_280488_(this.f_96547_, (String)textTitle, titleMinX, 50, 0);
            String s = "Warning: the vanilla client restricts titles to 15 characters. Set longer titles at your own risk";
            MutableComponent lengthWarning = Component.m_237115_((String)s);
            guiGraphics.m_280554_(this.f_96547_, (FormattedText)lengthWarning, 153, 116, 114, 0xFF3333);
        }
        if (!this.f_98067_) {
            String warning = "";
            if (this.m_98191_().length() > 256) {
                warning = "Over 256 char limit!";
            } else if (this.getCurrPageLineCount() > 14) {
                warning = "Over 14 line limit!";
            }
            if (!warning.isEmpty()) {
                guiGraphics.m_280488_(this.f_96547_, "Warning:", 5, 176, 0xFF3333);
                guiGraphics.m_280488_(this.f_96547_, warning, 5, 185, 0xFF3333);
            }
        }
    }

    public boolean m_98163_(int keyCode, int scanCode, int modifiers) {
        if (Screen.m_96630_((int)keyCode)) {
            this.f_98073_.m_95165_();
            return true;
        }
        return super.m_98163_(keyCode, scanCode, modifiers);
    }

    @Override
    public List<String> pagesAsList() {
        return new ArrayList<String>(this.f_98070_);
    }

    @Override
    public void bookChanged(boolean setModifiedFlag) {
        if (setModifiedFlag) {
            this.f_98066_ = true;
        }
        this.m_98080_();
    }

    @Override
    public void addFormattingCode(String formattingCode) {
        int selectionPos;
        TextFieldHelper editor = this.f_98067_ ? this.f_98073_ : this.f_98072_;
        int cursorPos = editor.m_95194_();
        if (cursorPos != (selectionPos = editor.m_95197_())) {
            editor.m_95179_(Math.min(cursorPos, selectionPos), false);
        }
        editor.m_95158_(formattingCode);
        if (cursorPos != selectionPos) {
            int extraCharCount = 2;
            if (!formattingCode.equals("\u00a7r")) {
                editor.m_95179_(Math.max(cursorPos, selectionPos) + extraCharCount, false);
                editor.m_95158_("\u00a7r");
                extraCharCount = 4;
            }
            if (cursorPos < selectionPos) {
                editor.m_95147_(cursorPos, selectionPos + extraCharCount);
            } else {
                editor.m_95147_(selectionPos, cursorPos + extraCharCount);
            }
        }
        this.bookChanged(true);
    }

    @Override
    public boolean isBookBeingSigned() {
        return this.f_98067_;
    }

    @Override
    public void insertNewPage(int atPageNum, String pageText) {
        if (atPageNum >= 100) {
            Ghostwriter.LOG.error("Cannot insert a page at index " + atPageNum + ". It would make the book too long");
            return;
        }
        while (this.f_98070_.size() < atPageNum) {
            this.f_98070_.add("");
        }
        this.f_98070_.add(atPageNum, pageText);
        this.bookChanged(true);
    }

    @Override
    public void setPageText(int pageNum, String pageText) {
        if (pageNum < 0 || pageNum > this.f_98070_.size() - 1) {
            Ghostwriter.LOG.error("Couldn't set text on page " + pageNum + " because it doesn't exist");
            return;
        }
        this.f_98070_.set(pageNum, pageText);
        this.bookChanged(true);
    }

    @Override
    public String getPageText(int pageNum) {
        if (pageNum < 0 || pageNum > this.f_98070_.size() - 1) {
            return "";
        }
        return (String)this.f_98070_.get(pageNum);
    }

    @Override
    public void removePage(int pageNum) {
        if (pageNum > this.f_98070_.size() - 1) {
            Ghostwriter.LOG.error("Can't remove page " + pageNum + ". It doesn't exist");
            return;
        }
        this.f_98070_.remove(pageNum);
        if (this.f_98070_.isEmpty()) {
            this.f_98070_.add("");
        }
        this.bookChanged(true);
    }

    @Override
    public void replaceBookPages(List<String> newPages) {
        this.f_98070_.clear();
        this.f_98070_.addAll(newPages);
        if (this.f_98070_.isEmpty()) {
            this.f_98070_.add("");
        }
        this.bookChanged(true);
    }

    @Override
    public void setBookTitle(String title) {
        this.f_98071_ = title;
        this.f_98073_.m_95193_();
    }

    @Override
    public Button addGhostButton(Button button) {
        return (Button)this.m_142416_((GuiEventListener)button);
    }

    @Override
    public int getCurrPage() {
        return this.f_98069_;
    }

    @Override
    public void setCurrPage(int pageNum) {
        if (pageNum < 0 || pageNum > this.f_98070_.size() - 1) {
            Ghostwriter.LOG.error("Couldn't move to page " + pageNum + ". It doesn't exist");
            pageNum = 0;
        }
        this.f_98069_ = pageNum;
        this.bookChanged(false);
    }

    @Override
    public int getBookPageCount() {
        return this.m_98181_();
    }

    @Override
    public void updateVanillaButtons() {
        super.m_98184_();
    }
}

